#


# **********************************************************************************
# data
# **********************************************************************************

# Home PC
setwd("G:/My Drive/PhD/Project #1_Characterisation of LOTR1/PI uptake")

# Laptop
#setwd("C:/Users/Andreas Kolbeck/Google Drive/PhD/Project #1_Characterisation of LOTR1/PI uptake")

library(readr)
mydata <- read_csv("G:/My Drive/PhD/Project #1_Characterisation of LOTR1/PI uptake/20200116_complementation lines_sorted for R.csv", 
                   col_types = cols(X10 = col_skip(), X11 = col_skip(), X12 = col_skip(), X13 = col_skip(), X14 = col_skip(), X4 = col_skip(),X5 = col_skip(), X6 = col_skip(), X7 = col_skip(), X8 = col_skip(), X9 = col_skip()))

#lotr1_PI_new$Genotype <- factor(lotr1_PI_new$Genotype,        # changing order of genotypes in plots
#                                
#                                levels = c("CASP1GFP", "lotr1-1", "sgn1-2", "lotr1-1 sgn1-2","sgn3-3", "lotr1-1 sgn3-3", "esb1-1", "lotr1-1 esb1-1")
#)  
mydata$Genotype <- factor(mydata$Genotype, levels = c("ctrl", "LOTR1", "SHR", "CIF2", "SCR", "CASP1", "ELTP", "C1", "35S"))

mydata$background <- factor(mydata$background, levels = c("wild-type", "lotr1"))

library(tidyverse)
library(dplyr)
mydata_lotr1 <- mydata %>%
  filter(background == "lotr1")
#mydata_lotr1$Genotype <- factor(mydata_lotr1$Genotype, levels = c("ctrl", "LOTR1", "SHR", "CIF2", "SCR", "CASP1", "ELTP", "C1", "35S"))

mydata_wt <- mydata %>%
  filter(background == "wild-type")
#mydata_wt$Genotype <- factor(mydata_wt$Genotype, levels = c("ctrl", "LOTR1", "SHR", "CIF2", "SCR", "CASP1", "ELTP", "C1", "35S"))


# **********************************************************************************
# Plots
# **********************************************************************************
# ------------------------------------
# Boxplot
# ------------------------------------

# ------------------------------------
# ggplots
# ------------------------------------

library(ggplot2)

# for lotr1
p1 <- ggplot(mydata_lotr1, aes(x=Genotype, y = Cells))+
  geom_boxplot()+
  xlab("")+
  #ylim(0,120)+
  ylab("Endodermal cells after onset of elongation")+
  xlab("Genotype")+
  #labs(title = "PI Block")+
  theme_classic()+
  theme(axis.text.x = element_text(color = "black", size = 12, angle = 45, hjust = .5, vjust = .5, face = "plain"),
                axis.text.y = element_text(color = "black", size = 12, angle = 0, hjust = .5, vjust = 0.5, face = "plain"),  
                axis.title.x = element_text(color = "black", size = 14, angle = 0, hjust = 0.5, vjust = 0, face = "plain"),
                axis.title.y = element_text(color = "black", size = 14, angle = 90, hjust = .5, vjust = 1.5, face = "plain"))+
  #scale_x_continuous(expand = c(0, 0), limits = c(0, 150)) + 
  scale_y_continuous(expand = c(0, 0), limits = c(0, 50))

p1 + annotate("text", x = 1:9, y = c(45,30,30,30,45,45,45,45,45), label = c("a","b","b","b","a","a","a","a","a"), size=5)


# for wild-type
p2 <- ggplot(mydata_wt, aes(x=Genotype, y = Cells))+
  geom_boxplot()+
  xlab("")+
  #ylim(0,120)+
  ylab("Endodermal cells after onset of elongation")+
  xlab("Genotype")+
  #labs(title = "PI Block")+
  theme_classic()+
  theme(axis.text.x = element_text(color = "black", size = 12, angle = 45, hjust = .5, vjust = .5, face = "plain"),
        axis.text.y = element_text(color = "black", size = 12, angle = 0, hjust = .5, vjust = 0.5, face = "plain"),  
        axis.title.x = element_text(color = "black", size = 14, angle = 0, hjust = 0.5, vjust = 0, face = "plain"),
        axis.title.y = element_text(color = "black", size = 14, angle = 90, hjust = .5, vjust = 1.5, face = "plain"))+
  #scale_x_continuous(expand = c(0, 0), limits = c(0, 150)) + 
  scale_y_continuous(expand = c(0, 0), limits = c(0, 50))

p2 + annotate("text", x = 1:9, y = c(30,30,30,30,30,30,45,45,45), label = c("a","a","a","a","a","a","b","b","b"), size=5)



# Save plot as PDF file
pdf("20200116_PI uptake complementation lines.pdf", useDingbats=FALSE, width=8, height=5)

p1 + annotate("text", x = 1:9, y = c(45,30,30,30,45,45,45,45,45), label = c("a","b","b","b","a","a","a","a","a"), size=5)
p2 + annotate("text", x = 1:9, y = c(30,30,30,30,30,30,45,45,45), label = c("a","a","a","a","a","a","b","b","b"), size=5)

dev.off()


# **********************************************************************************
# Statistics
# **********************************************************************************
library(agricolae)

# Anova for lotr1
results <- aov(Cells~Genotype, data = mydata_lotr1)

summary(results)
#
HSD.test(results, "Genotype", group=TRUE, console=TRUE,      # 
         alpha = 0.001                                       # increase significance level
)

# Anova for wild-type
results <- aov(Cells~Genotype, data = mydata_wt)

summary(results)
#
HSD.test(results, "Genotype", group=TRUE, console=TRUE,      # 
         alpha = 0.001                                       # increase significance level
)



# Linear regression analysis
model <- lm(data = mydata, Cells ~ Genotype + background)
summary(model)

coefficients(model)
confint(model, level=0.95)
residuals(model)
plot(residuals(model))
anova(model)
influence(model)


#layout(matrix(c(1,2,3,4),2,2)) # optional 4 graphs/page
plot(model)




# Test
p3 <- ggplot(mydata, aes(x=Genotype, y = Cells, fill = background))+
  geom_boxplot()+
  xlab("")+
  #ylim(0,120)+
  ylab("Endodermal cells after onset of elongation")+
  xlab("Genotype")+
  #labs(title = "PI Block")+
  theme_classic()+
  theme(axis.text.x = element_text(color = "black", size = 12, angle = 90, hjust = .5, vjust = .5, face = "plain"),
        axis.text.y = element_text(color = "black", size = 12, angle = 0, hjust = .5, vjust = 0.5, face = "plain"),  
        axis.title.x = element_text(color = "black", size = 14, angle = 0, hjust = 0.5, vjust = 0, face = "plain"),
        axis.title.y = element_text(color = "black", size = 14, angle = 90, hjust = .5, vjust = 1.5, face = "plain"))+
  scale_y_continuous(expand = c(0, 0), limits = c(0, 40))+
  scale_fill_manual(values = c("white", "darkgrey"))+
  theme(legend.position="top")


# Save full plot
pdf("20200116_PI uptake complementation lines_full.pdf", useDingbats=FALSE, width=8, height=5)

p3

dev.off()

# Anova for all data
# generate unique IDs for comparison
mydata_new <- mydata %>%
  unite(ID, c("background", "Genotype"))


results <- aov(Cells~ID, data = mydata_new)
summary(results)

#
HSD.test(results, "ID", group=TRUE, console=TRUE,      # 
         alpha = 0.001                                       # increase significance level
)


